/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.easy_forge_compat;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.montoyo.mcef.client.UnsafeUtil;

public class Configuration {
    private final ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
    ForgeConfigSpec spec;
    private final ModConfig.Type type;
    private final String file;
    private final HashMap<String, Pair<Supplier<Object>, Consumer<Object>>> entries = new HashMap();
    HashMap<String, ForgeConfigSpec.Builder> sections = new HashMap();

    public Configuration(String file, ModConfig.Type type) {
        this.type = type;
        this.file = file;
    }

    public void getBoolean(String optName, String section, boolean defaultValue, String desc, Field field) {
        this.configBuilder.push(section);
        long handle = UnsafeUtil.getHandle(field);
        Object base = UnsafeUtil.getBase(field);
        ForgeConfigSpec.BooleanValue value = this.configBuilder.comment(desc.replace(". ", "\n")).define(optName, defaultValue);
        this.entries.put(section + "." + optName, (Pair<Supplier<Object>, Consumer<Object>>)Pair.of(() -> ((ForgeConfigSpec.BooleanValue)value).get(), v -> UnsafeUtil.setBoolean(base, handle, (Boolean)v)));
        UnsafeUtil.setBoolean(base, handle, defaultValue);
        this.configBuilder.pop();
    }

    public void getString(String optName, String section, String defaultValue, String desc, Consumer<String> valueConsumer) {
        this.configBuilder.push(section);
        ForgeConfigSpec.ConfigValue value = this.configBuilder.comment(desc.replace(". ", "\n")).define(optName, (Object)defaultValue);
        this.entries.put(section + "." + optName, (Pair<Supplier<Object>, Consumer<Object>>)Pair.of(() -> ((ForgeConfigSpec.ConfigValue)value).get(), v -> valueConsumer.accept((String)v)));
        valueConsumer.accept(defaultValue);
        this.configBuilder.pop();
    }

    public void getString(String optName, String section, String defaultValue, String desc, Field field) {
        long handle = UnsafeUtil.getHandle(field);
        Object base = UnsafeUtil.getBase(field);
        this.getString(optName, section, defaultValue, desc, (String value) -> UnsafeUtil.setObject(base, handle, value));
    }

    protected void clone(UnmodifiableConfig src, CommentedConfig dst) {
        for (String s : src.valueMap().keySet()) {
            Object entry = src.get(s);
            if (entry instanceof AbstractConfig) {
                AbstractConfig cfg1 = (AbstractConfig)entry;
                CommentedConfig nested = CommentedConfig.inMemory();
                this.clone((UnmodifiableConfig)cfg1, nested);
                dst.add(s, (Object)nested);
                continue;
            }
            if (entry instanceof ForgeConfigSpec.ValueSpec) {
                ForgeConfigSpec.ValueSpec spec = (ForgeConfigSpec.ValueSpec)entry;
                dst.setComment(s, spec.getComment());
                dst.add(s, spec.getDefault());
                continue;
            }
            dst.add(s, entry);
        }
    }

    public void save() {
        this.spec = this.configBuilder.build();
        File fl = new File(FMLPaths.CONFIGDIR.get().toFile().getAbsoluteFile() + "/" + this.file);
        try {
            if (fl.exists()) {
                CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((String)fl.toString()).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile(newfile, configFormat)).writingMode(WritingMode.REPLACE).build();
                cfg.load();
                this.spec.acceptConfig((CommentedConfig)cfg);
                cfg.save();
                this.onConfigChange((Config)this.spec.getSpec());
            } else {
                CommentedConfig cfg = CommentedConfig.inMemory();
                this.clone(this.spec.getSpec(), cfg);
                FileOutputStream outputStream = new FileOutputStream(fl);
                TomlWriter writer = new TomlWriter();
                outputStream.write(writer.writeToString((UnmodifiableConfig)cfg).getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    private boolean setupConfigFile(Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.createFile(file, new FileAttribute[0]);
        conf.initEmptyFile(file);
        return true;
    }

    public void onConfigChange(Config config) {
        for (String s : this.entries.keySet()) {
            Pair<Supplier<Object>, Consumer<Object>> entry = this.entries.get(s);
            ((Consumer)entry.getSecond()).accept(((Supplier)entry.getFirst()).get());
        }
    }
}

